﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using System.Net.Mail;
using Gemini.Core.WebApplication.Base;
using PI.ZB.N1200.ELearning.BL.APIMobile.Model.Data;
using PI.ZB.N1200.ELearning.BL.APIMobile.Model;
using Gemini.Core.BL.Interface;

namespace PI.ZB.N1200.ELearning.WebApplication.API
{
    public partial class ELearning : Gemini.Core.WebApplication.Base.APIComponent
    {
        internal class MethodUserProfile : BaseAPIMethod
        {

            public MethodUserProfile(ELearning Component)
                : base(Component)
            {
            }

            public override string Name
            {
                get { return "usersprofile"; }
            }

            protected override bool DoValidate()
            {
                return true;
            }

            protected override void DoReadRequestParams()
            {
                // tutaj nic nie czytamy z sesji
            }

            protected override GResponseData DoGetGResponseData()
            {
                if (User != null)
                {
                    GUserProfile _userProfile = Component.BLELearning.APIMobile.GetUserProfile(User, Component.Environment.Domain);

                    if (_userProfile != null)
                    {
                        StatusCode = StatusCodeType.OK;
                        return new GResponseData_InnerData() { InnerData = _userProfile };
                    }
                    else
                    {
                        AddErrorMessage("Nie odzyskano profilu ucznia.");
                        StatusCode = StatusCodeType.NotFound;
                    }
                }
                return null;
            }
        }
    }
}